#ifndef _LED_H_
#define _LED_H_

#include "ht32.h"

/*-------Handware interface define-----------------------------------------*/
#define	LED1_PORT					HT_GPIOA
#define	LED1_IO						GPIO_PIN_14			/* PA14 */
#define	LED1_AFIO_PORT				GPIO_PA
#define	LED1_AFIO_FUN				AFIO_FUN_GPIO

#define	LED2_PORT					HT_GPIOA
#define	LED2_IO						GPIO_PIN_11       /* PA11 */
#define	LED2_AFIO_PORT				GPIO_PA
#define	LED2_AFIO_FUN				AFIO_FUN_GPIO

#define	LED3_PORT					HT_GPIOA
#define	LED3_IO						GPIO_PIN_10       /* PA10 */
#define	LED3_AFIO_PORT				GPIO_PA
#define	LED3_AFIO_FUN				AFIO_FUN_GPIO

#define	LED4_PORT					HT_GPIOA
#define	LED4_IO						GPIO_PIN_8        /* PA8 */
#define	LED4_AFIO_PORT				GPIO_PA
#define	LED4_AFIO_FUN				AFIO_FUN_GPIO

#define	LEDP_PORT					HT_GPIOA
#define	LEDP_IO						GPIO_PIN_15       /* PA15 */
#define	LEDP_AFIO_PORT				GPIO_PA
#define	LEDP_AFIO_FUN				AFIO_FUN_GPIO

#define	LED1_ON()					(LED1_PORT->RR = LED1_IO)
#define	LED1_OFF()					(LED1_PORT->SRR = LED1_IO)
#define	LED1_TOGGLE()				((LED1_PORT->DOUTR & LED1_IO)?LED1_ON():LED1_OFF())
#define	LED2_ON()					(LED2_PORT->RR = LED2_IO)
#define	LED2_OFF()					(LED2_PORT->SRR = LED2_IO)
#define	LED2_TOGGLE()				((LED2_PORT->DOUTR & LED2_IO)?LED2_ON():LED2_OFF())
#define	LED3_ON()					(LED3_PORT->RR = LED3_IO)
#define	LED3_OFF()					(LED3_PORT->SRR = LED3_IO)
#define	LED3_TOGGLE()				((LED3_PORT->DOUTR & LED3_IO)?LED3_ON():LED3_OFF())
#define	LED4_ON()					(LED4_PORT->RR = LED4_IO)
#define	LED4_OFF()					(LED4_PORT->SRR = LED4_IO)
#define	LED4_TOGGLE()				((LED4_PORT->DOUTR & LED4_IO)?LED4_ON():LED4_OFF())
#define	LEDP_ON()					(LEDP_PORT->RR = LEDP_IO)
#define	LEDP_OFF()					(LEDP_PORT->SRR = LEDP_IO)
#define	LEDP_TOGGLE()				((LEDP_PORT->DOUTR & LEDP_IO)?LEDP_ON():LEDP_OFF())

#define	MAX_LED_NUM					5
#define  LED1     					(1 << 0)
#define  LED2     					(1 << 1)
#define  LED3     					(1 << 2)
#define  LED4     					(1 << 3)
#define  LEDP     					(1 << 4)

void LED_InterfaceConfigure(void);
void LED_AlwaysON(u8 led);
void LED_AlwaysOFF(u8 led);
void LED_FlashEnable(u8 led,u16 timer);
void LED_FlashProcess(void);
void LEDProcess_ms(void);
void LED_EnableFlag_ms(u8 led,u16 timer);

#endif /* _LED_H_ */
